<?php
namespace UiCore\Settings;

use function ElementorDeps\DI\value;

defined('ABSPATH') || exit();

/**
 * Performance settings.
 *
 * @return array
 */

$category = _x('Performance', 'Admin - Theme Options', 'uicore-framework');
$category_slug = 'performance';

return [
    self::add_toggle([
        'id' => 249,
        'index' => 'performance_emojy',
        'adv' => true,
        'name' => _x('Emoji Script', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Turn off to disable the Emoji script (wp-emoji-release.min.js).', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('emoji', 'Admin - Theme Options Search', 'uicore-framework'),
        'module' => 'frontend',
        'default' => 'true',
        'visible' => true,
    ]),
    self::add_toggle([
        'adv' => true,
        'index' => 'performance_embed',
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'true',
        'module' => 'frontend',
        'id' => 259,
        'name' => _x('WP Embed', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Turn off to disable WP Embed Script (wp-embed.min.js).', 'Admin - Theme Options', 'uicore-framework'),
        'category' => _x('Performance', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('wp embed', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
    ]),
    self::add_toggle([
        'adv' => true,
        'index' => 'performance_eicon',
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'true',
        'module' => 'frontend',
        'id' => 250,
        'name' => _x('Elementor Icons (eicon)', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Turn off to disable the default Elementor icon pack.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => _x('Performance', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('eicon icon elementor', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
    ]),
    self::add_toggle([
        'adv' => true,
        'index' => 'performance_fa',
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'true',
        'module' => 'frontend',
        'id' => 251,
        'name' => _x('Font Awesome (fa)', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Turn off to disable Font Awesome icon pack.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => _x('Performance', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('font awesome fa', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
    ]),
    self::add_toggle([
        'adv' => true,
        'index' => 'performance_block_style',
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'true',
        'module' => 'frontend',
        'id' => 252,
        'name' => _x('Default WP Block Styles', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Turn off to disable the default styles from Gutenberg block library.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => _x('Performance', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('block styles', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
    ]),
    self::add_toggle([
        'adv' => true,
        'index' => 'performance_widgets',
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'true',
        'module' => 'frontend',
        'id' => 260,
        'name' => _x('Widgets', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Turn off to disable sidebar and widgets styles.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => _x('Performance', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('widgets sidebar', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
    ]),
    self::add_toggle([
        'adv' => true,
        'index' => 'header_top',
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'true',
        'module' => 'frontend',
        'id' => 253,
        'name' => _x('Top Banner', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Turn off to disable top banner.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => _x('Performance', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('top banner', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
    ]),
    self::add_toggle([
        'adv' => true,
        'index' => 'header',
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'true',
        'module' => 'frontend',
        'id' => 254,
        'name' => _x('Header', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Turn off to disable header globally.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => _x('Performance', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('header', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
    ]),
    self::add_toggle([
        'adv' => true,
        'index' => 'footer',
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'true',
        'module' => 'frontend',
        'id' => 255,
        'name' => _x('Footer', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Turn off to disable footer globally.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => _x('Performance', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('footer', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
    ]),
    self::add_toggle([
        'adv' => true,
        'index' => 'copyrights',
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'true',
        'module' => 'frontend',
        'id' => 256,
        'name' => _x('Copyright Bar', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Turn off to disable copyright bar globally.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => _x('Performance', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('copright', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
    ]),
    self::add_toggle([
        'adv' => true,
        'index' => 'performance_animations',
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'true',
        'module' => 'frontend',
        'id' => 257,
        'name' => _x('Animations', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Turn off to disable all animations.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => _x('Performance', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('animations', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
    ]),
    self::add_toggle([
        'adv' => true,
        'category' => $category,
        'category_slug' => $category_slug,
        'id' => 420,
        'index' => 'ui_bl_local_fonts',
        'module' => 'uicore_blocks_front_options', // TODO: valid module?
        'default' => 'false',
        'name' => _x('Enable Local Fonts', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Enable / Disable local fonts loading.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('performance local fonts', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => \class_exists('\UiCoreBlocks\Base'),
    ]),
    self::add_toggle([
        'category' => $category,
        'category_slug' => $category_slug,
        'id' => 419,
        'adv' => true,
        'type' => 'toggle',
        'index' => 'performance_inline_critical',
        'module' => 'admin',
        'default' => 'false',
        'name' => _x('Enable Inline Critical CSS', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Enable / Disable inline critical CSS generation.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => _x('Performance', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('performance inline critical css', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
    ]),
    self::add_toggle([
        'adv' => true,
        'index' => 'performance_smart_preload',
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'true',
        'module' => 'admin',
        'id' => 258,
        'name' => _x('Smart Preload', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Turn on to enable smart preloading of inner pages.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => _x('Performance', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('smart preload', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
    ]),
    self::add_toggle([
        'adv' => true,
        'index' => 'performance_preload_img',
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'true',
        'module' => 'frontend',
        'id' => 262,
        'name' => _x('Preload Featured Images', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Turn on to preload page title featured image.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => _x('Performance', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('preload featured image', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
    ]),

    self::add_repeater_select([
        'id' => 999, // TODO: coulndt find the ID
        'adv' => true,
        'index' => 'performance_preload',
        'name' => _x('Preload Resources', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Add custom resources to preload.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('preload custom font image script document style', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => [
            [
                'url' => '',
                'as'  => ''
            ]
        ],
        'module' => 'frontend',
        'visible' => true,
        'placeholder' => _x('Select Type', 'Admin - Theme Options', 'uicore-framework'),
        'allow_empty' => false,
        'show_labels' => false,
        'searchable' => false,
        'close_on_select' => false,
        'options' => [
            [
                'name' => _x('Document', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'document',
            ],
            [
                'name' => _x('Font', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'font',
            ],
            [
                'name' => _x('Image', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'image',
            ],
            [
                'name' => _x('Script', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'script',
            ],
            [
                'name' => _x('Style', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'style',
            ],
        ],
    ]),
];